<?php
$functionsFile = "../includes/functions.php";
ini_set("display_errors",0);
include($functionsFile);
$dnsInfo = loadAllDNS(true);
 $iboInfo = getDbEntry("ibo_settings");
$allowedCharacters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
function getEncryptKeyPosition($str)
{
	global $allowedCharacters;
	return strpos($allowedCharacters,$str);
}
function getEncryptPositionString($i)
{
	global $allowedCharacters;
	return strval($allowedCharacters[$i]);
}
function getDecodedString($str, $type=1)
{
	$endKey =  substr($str,strlen($str) - 2,strlen($str) - 2);
	if($type == 1)
	{
		 $encryptKeyPosition = getEncryptKeyPosition($endKey[0]) ;
		$encryptKeyPosition2 = getEncryptKeyPosition($endKey[1]) ;
	}
	else
	{
		$encryptKeyPosition = getEncryptKeyPosition($endKey[1]) ;
		$encryptKeyPosition2 = getEncryptKeyPosition($endKey[0]) ;
	}
	$substring = substr($str,0,strlen($str) - 2);
	return base64_decode(trim(substr($substring,0,$encryptKeyPosition) . substr($substring,($encryptKeyPosition + $encryptKeyPosition2),strlen($substring))));
}
function getEncodedString($str)
{
	$enc = base64_encode($str);
	$position1 = rand(0,61);
	$position2 = rand(0,61);
	$key1 = getEncryptPositionString($position2);
	$key2 = getEncryptPositionString($position1);
	$firstPart = substr($enc,0,$position1);
	$secondPart = substr($enc,($position1),strlen($enc));
	$padding = "";
	for($i=0; $i < $position2; $i++)
	{
		$paddingRand = rand(0,61);
		$padding .= getEncryptPositionString($paddingRand);
	}
	return $firstPart . $padding . $secondPart . $key2 . $key1;
}
$jsonIn = file_get_contents("php://input");
$resonse = json_decode($jsonIn,true);
$decoded = getDecodedString($resonse['data']);
if($_GET['path'] == "auth")
{
	$authData = json_decode($decoded,true);
	$macAddress = base64_decode($authData['app_device_id']);
	$macAddress = substr($macAddress,0,12);
	$formattedMac = preg_replace('/..(?!$)/', '$0:', $macAddress);
	$basicResponse = getResponseBasic();
	$basicResponse['urls'] = array();
	$accounts = getUsersForMac($formattedMac);
	foreach($dnsInfo as $thisDns)
	{
		$username = "";
		$password = "";
		if(isset($accounts[$thisDns['id']]))
		{
			$username = $accounts[$thisDns['id']]['username'];
			$password = $accounts[$thisDns['id']]['password'];
		}
	$portal = [
		   "is_protected" => 0, 
		   "id" => $thisDns['id'], 
		   "url" => $thisDns['portal'] . "/get.php?username=" .$username .  "&password=" .$password . "&type=m3u_plus&output=ts", 
		   "name" => $thisDns['name'], 
		   "type" => "xc", 
		   "created_at" => "2023-03-26 16:42:48", 
		   "updated_at" => "2023-03-26 16:42:48" 
		];
	$basicResponse['urls'][] = $portal;
	}
	
	$basicResponse['note_title'] = $iboInfo['welcome_header'];
	$basicResponse['note_content'] = $iboInfo['welcome_text'];
	$basicResponse['mac_address'] = $formattedMac;
	$returnable = array();
	$returnable['data'] = getEncodedString(json_encode($basicResponse));
	//echo $returnable['data'];
	//echo getDecodedString($returnable['data'],0);exit;
	echo json_encode($returnable);
}
else if($_GET['path'] == "update")
{
	$playlistData = json_decode($decoded,true);
	
	$macAddress = $playlistData['mac_address']; 
	$newURL = $playlistData['playlist_url']; 
	$dnsId = $playlistData['playlist_id'];  
	$playlistName = $playlistData['playlist_name'];  
	$urlParts = parse_url($newURL, PHP_URL_QUERY);
    parse_str($urlParts,$parsed);
	$newUsername = $parsed['username'];
	$newPassword =$parsed['password'];
	addOrUpdateAccount($dnsId, $macAddress, $newUsername, $newPassword);
$response = [
   "success" => 1, 
   "id" => $dnsId, 
   "name" => $playlistName, 
   "url" => $newURL 
]; 
echo json_encode($response);
 
 	
}
function getResponseBasic()
{
 $response = [
   "android_version_code" => "1.0.0", 
   "apk_url" => "http://google.com", 
   "device_key" => "399513", 
   "expire_date" => "2024-03-26", 
   "is_google_paid" => false, 
   "is_trial" => 0, 
   "languages" => json_decode(file_get_contents("language.json"),true), 
   "mac_registered" => true, 
   "themes" => [
               ], 
   "trial_days" => 7, 
   "plan_id" => "36269518", 
   "mac_address" => "", 
   "pin" => "0000", 
   "price" => "7.99", 
   "app_version" => "3.1", 
   "apk_link" => "http://google.com", 
   "urls" => [], 
   "note_title" => "", 
   "note_content" => ""
]; 
return $response;
}
