<?php
ini_set("display_errors", 0);
error_reporting(0);

session_start();
require_once("includes/functions.php");
if (!isset($_SESSION[$authVar]) || !$dbIsLatest) {
  header("Location: index.php");
  exit;
}
$includePage = "dns.php";
$navCss = "active bg-gradient-secondary";
$subNavCss = "active";
$dnsClass = "";
$notificationsClass = "";
$profileClass = "";
$femtoClass = "";
$introClass = "";

if (isset($_GET['dns'])) {
  $dnsInfo = loadAllDNS();
  $dnsClass = $navCss;
} else if (isset($_GET['dns-add'])) {
  $dnsClass = $navCss;
  $includePage = "dns-add.php";
} else if (isset($_GET['profile'])) {
  $userInfo = loadProfile(1);
  $panelRoot = loadPanelRoot();
  $profileClass = $navCss;
  $includePage = "profile.php";
} else if (isset($_GET['dns-edit'])) {
  $dnsClass = $navCss;
  $includePage = "dns-edit.php";
  $dnsId = $_GET['id'];
  $dnsEditInfo = loadDns($dnsId);
}else if (isset($_GET['ibo-settings'])) {
  $iboClass = $navCss;
  $includePage = "ibo-app.php";
  $iboInfo = getDbEntry("ibo_settings");
} 
else if (isset($_GET['ibo-users'])) { 

	$dns = $_GET['id'];
	$iboUsersClass = $navCss;
	$includePage = "ibo-users.php";
	$iboUsers =  getUsersForDns($dns);
	$dnsInfo = loadDNS($dns);
}
else if (isset($_GET['ibo-users-add'])) { 

	$dns = $_GET['id'];
	$iboUsersClass = $navCss;
	$includePage = "ibo-users-add.php";
	$dnsInfo = loadDNS($dns);
}
else if (isset($_GET['ibo-users-edit'])) { 

	$id = $_GET['id'];
	$dns = $_GET['section'];
	$iboUsersClass = $navCss;
	$includePage = "ibo-users-edit.php";
	$iboUserInfo = loadIBOUser($dns, $id);
}
else if (isset($_GET['hax-sports-categories'])) {
	$haxSportsCategoriesClass = $navCss;
  $haxCategoryInfo = loadHAXSportsCategories();
  $includePage = "hax-sports-categories.php";
} else if (isset($_GET['hax-sports-categories-add'])) {
	$haxSportsCategoriesClass = $navCss;
  $includePage = "hax-sports-categories-add.php";
} else if (isset($_GET['hax-sports-categories-edit'])) {
	$haxSportsCategoriesClass = $navCss;
  $haxCategoryEditInfo = loadHAXSportsCategory($_GET['id']);
  $includePage = "hax-sports-categories-edit.php";
} else if (isset($_GET['hax-sports-teams'])) {
  	$haxSportsTeamsClass = $navCss;
  $haxTeamsInfo = loadHAXSportsTeams();
  $includePage = "hax-sports-teams.php";

} else if (isset($_GET['hax-sports-events'])) {	
	$haxSportsEventsClass = $navCss;
  $haxEventsInfo = loadHAXSportsEventsDisplay();
  $includePage = "hax-sports-events.php";
} 
else 
{
  $dnsInfo = loadAllDNS();
  $dnsClass = $navCss;
}

?><!--
=========================================================
* Material Dashboard 2 - v3.0.4
=========================================================

* Product Page: https://www.creative-tim.com/product/material-dashboard
* Copyright 2022 Creative Tim (https://www.creative-tim.com)
* Licensed under MIT (https://www.creative-tim.com/license)
* Coded by Creative Tim

=========================================================

* The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
-->
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <link rel="apple-touch-icon" sizes="180x180" href="assets/fav/apple-touch-icon.png">
  <link rel="icon" type="image/png" sizes="32x32" href="assets/fav/favicon-32x32.png">
  <link rel="icon" type="image/png" sizes="16x16" href="assets/fav/favicon-16x16.png">
  <link rel="manifest" href="site.webmanifest">
  <link rel="mask-icon" href="assets/fav/safari-pinned-tab.svg" color="#5bbad5">
  <meta name="msapplication-TileColor" content="#da532c">
  <meta name="theme-color" content="#ffffff">
  <title>
    OnePanel <?php echo $appCat; ?> <?php echo $appVersion; ?>
  </title>
  <!--     Fonts and icons     -->
  <link rel="stylesheet" type="text/css" href="https://fonts.googleapis.com/css?family=Roboto:300,400,500,700,900|Roboto+Slab:400,700" />
  <!-- Nucleo Icons -->
  <link href="assets/css/nucleo-icons.css" rel="stylesheet" />
  <link href="assets/css/nucleo-svg.css" rel="stylesheet" />
  <!-- Font Awesome Icons -->
  <script src="https://kit.fontawesome.com/42d5adcbca.js" crossorigin="anonymous"></script>
  <!-- Material Icons -->
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons+Round" rel="stylesheet">
  <!-- CSS Files -->
  <link id="pagestyle" href="assets/css/material-dashboard.min.css?v=3.0.4" rel="stylesheet" />

</head>

<body class="g-sidenav-show  bg-gray-200">
  <aside class="sidenav navbar navbar-vertical navbar-expand-xs border-0 border-radius-xl my-3 fixed-start ms-3   bg-gradient-dark" id="sidenav-main">
    <div class="sidenav-header">
      <a class="navbar-brand m-0" style="text-align:center;">
        <span class="ms-1 font-weight-bold text-white">Logged in as <?php echo $_SESSION[$authVar]; ?></span>
      </a>

    </div>
    <div class="collapse navbar-collapse  w-auto " id="sidenav-collapse-main">
      <ul class="navbar-nav">
        <li class="nav-item">
          <a class="nav-link text-white <?php echo $dnsClass; ?>" href="dashboard.php?dns">
            <div class="text-white text-center me-2 d-flex align-items-center justify-content-center">
              <i class="material-icons opacity-10">dns</i>
            </div>
            <span class="nav-link-text ms-1">DNS</span>
          </a>
        </li>
        
        <li class="nav-item">
          <a class="nav-link text-white <?php echo $iboClass; ?>" href="dashboard.php?ibo-settings">
            <div class="text-white text-center me-2 d-flex align-items-center justify-content-center">
              <i class="material-icons opacity-10">play_circle</i>
            </div>
            <span class="nav-link-text ms-1">IBO App Settings</span>
          </a>
        </li>
		 <li class="nav-item">
          <a class="nav-link text-white <?php echo $haxSportsCategoriesClass; ?>" href="dashboard.php?hax-sports-categories">
            <div class="text-white text-center me-2 d-flex align-items-center justify-content-center">
              <i class="material-icons opacity-10">sports_soccer</i>
            </div>
            <span class="nav-link-text ms-1">Sports Categories</span>
          </a>
        </li>
		 <li class="nav-item">
          <a class="nav-link text-white <?php echo $haxSportsEventsClass; ?>" href="dashboard.php?hax-sports-events">
            <div class="text-white text-center me-2 d-flex align-items-center justify-content-center">
              <i class="material-icons opacity-10">sports_soccer</i>
            </div>
            <span class="nav-link-text ms-1">Sports Events</span>
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link text-white <?php echo $profileClass; ?>" href="dashboard.php?profile">
            <div class="text-white text-center me-2 d-flex align-items-center justify-content-center">
              <i class="material-icons opacity-10">settings</i>
            </div>
            <span class="nav-link-text ms-1">Settings</span>
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link text-white " href="logout.php">
            <div class="text-white text-center me-2 d-flex align-items-center justify-content-center">
              <i class="material-icons opacity-10">logout</i>
            </div>
            <span class="nav-link-text ms-1">Log out</span>
          </a>
        </li>

      </ul>
    </div>
    <div class="sidenav-footer position-absolute w-100 bottom-0 ">
      <div class="mx-3">
        <a target="_blank" href="https://t.me/AndyHax">
          <img src="assets/img/OnePanel.png" style="max-width:100%;">
        </a>
      </div>
    </div>
  </aside>
  <main class="main-content position-relative max-height-vh-100 h-100 border-radius-lg ">
    <!-- Navbar -->
    <nav class="navbar navbar-main navbar-expand-lg px-0 mx-4 shadow-none border-radius-xl" id="navbarBlur" data-scroll="true">
      <div class="container-fluid py-1 px-3">
        <div class="collapse navbar-collapse mt-sm-0 mt-2 me-md-0 me-sm-4" id="navbar">

          <ul class="navbar-nav  justify-content-end">

            <li class="nav-item d-xl-none ps-3 d-flex align-items-center">
              <a href="javascript:;" class="nav-link text-body p-0" id="iconNavbarSidenav">
                <div class="sidenav-toggler-inner">
                  <i class="sidenav-toggler-line"></i>
                  <i class="sidenav-toggler-line"></i>
                  <i class="sidenav-toggler-line"></i>
                </div>
              </a>
            </li>
          </ul>
        </div>
      </div>
    </nav>
    <!-- End Navbar -->
    <div class="container-fluid py-4">
      <!--Start  include -->
      <?php include "includes/" . $includePage; ?>
      <!--End  include -->
      <footer class="footer py-4  ">
        <div class="container-fluid">
          <div class="row align-items-center justify-content-lg-between">
            <div class="col-lg-6 mb-lg-0 mb-4">
              <div class="copyright text-center text-sm text-muted text-lg-start">
                OnePanel <?php echo $appCat; ?> <?php echo $appVersion; ?>
                <br>
                <a target="_blank" href="https://t.me/AndyHax">
                  <img src="assets/img/logos/telegram.png" style="max-width:30px;"> AndyHax
                </a>

                <br>
              </div>
            </div>
           
          </div>
        </div>
      </footer>
    </div>
  </main>

  <!--   Core JS Files   -->
  <script src="assets/js/core/popper.min.js"></script>
  <script src="assets/js/core/bootstrap.min.js"></script>
  <script src="assets/js/plugins/perfect-scrollbar.min.js"></script>
  <script src="assets/js/plugins/smooth-scrollbar.min.js"></script>
  <script type="text/javascript">

  </script>
  <script>
    var win = navigator.platform.indexOf('Win') > -1;
    if (win && document.querySelector('#sidenav-scrollbar')) {
      var options = {
        damping: '0.5'
      }
      Scrollbar.init(document.querySelector('#sidenav-scrollbar'), options);
    }
  </script>
  <!-- Github buttons -->
  <script async defer src="https://buttons.github.io/buttons.js"></script>
  <!-- Control Center for Material Dashboard: parallax effects, scripts for the example pages etc -->
  <script src="assets/js/material-dashboard.min.js?v=3.0.4"></script>
  <script>
    function changeSelectedDns(that) {
      let dnsId = document.getElementById("streamprovider").value;
      var xhr = new XMLHttpRequest();
      var url = 'action.php?get_categories=' + dnsId;
      xhr.open("GET", url, true);
      xhr.onreadystatechange = function() {
        if (this.readyState == 4 && this.status == 200) {
          let ele = document.getElementById("stream_category");
          let ele2 = document.getElementById("stream_channel");
          ele.innerHTML = '';
          ele2.innerHTML = '';
          const myArr = JSON.parse(this.responseText);
          for (let i = 0; i < myArr.length; i++) {
            ele.innerHTML = ele.innerHTML +
              '<option value="' + myArr[i]['id'] + '">' + myArr[i]['category_name'] + '</option>';
          }
        }
      }
      xhr.send();
    }

    function changeSelectedCategory() {
      let catId = document.getElementById("stream_category").value;
      var xhr = new XMLHttpRequest();
      var url = 'action.php?get_channels=' + catId;
      xhr.open("GET", url, true);
      xhr.onreadystatechange = function() {
        if (this.readyState == 4 && this.status == 200) {
          let ele = document.getElementById("stream_channel");
          ele.innerHTML = '';

          const myArr = JSON.parse(this.responseText);
          for (let i = 0; i < myArr.length; i++) {
            ele.innerHTML = ele.innerHTML +
              '<option value="' + myArr[i]['id'] + '">' + myArr[i]['channel_name'] + '</option>';
          }
        }
      }
      xhr.send();
    }

    function addEventStream(eventId) {
      let chanId = document.getElementById("stream_channel").value;
      var xhr = new XMLHttpRequest();
      var url = 'action.php?add_event_stream=' + eventId + "&stream=" + chanId;
      xhr.open("GET", url, true);
      xhr.onreadystatechange = function() {
        if (this.readyState == 4 && this.status == 200) {
          //reload the table
          loadStreamsTable(eventId);
        }
      }
      xhr.send();
      return false;
    }

    function delEventStream(eventId, channelId) {
      var xhr = new XMLHttpRequest();
      var url = 'action.php?del_event_stream=' + eventId + "&stream=" + channelId;
      xhr.open("GET", url, true);
      xhr.onreadystatechange = function() {
        if (this.readyState == 4 && this.status == 200) {
          //reload the table
          loadStreamsTable(eventId);
        }
      }
      xhr.send();
      return false;
    }

    function loadStreamsTable(eventId) {

      var xhr = new XMLHttpRequest();
      var url = 'action.php?get_event_streams=' + eventId;
      xhr.open("GET", url, true);
      xhr.onreadystatechange = function() {
        if (this.readyState == 4 && this.status == 200) {
          document.getElementById("streamtablecontainer").innerHTML = this.responseText;
        }
      }
      xhr.send();
      return false;
    }

    function toggleOvpnType(that) {

      if (that.value == "file") {
        document.getElementById("ovpnFileUpload").style.display = "";
        document.getElementById("ovpnPathEntry").style.display = "none";
      } else {
        document.getElementById("ovpnFileUpload").style.display = "none";
        document.getElementById("ovpnPathEntry").style.display = "";
      }
    }
  </script>
</body>

</html>